<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInterviewPreparationTable extends Migration
{
    public function up()
    {
        Schema::create('interview_preparation', function (Blueprint $table) {
            $table->id('Interview_preparation_id');
            $table->unsignedBigInteger('User_id');
            $table->enum('Tool_type', ['mock_interview', 'practice_test'])->notNullable();
            $table->string('Title', 255)->notNullable()->comment('Name of the mock interview or practice test');
            $table->unsignedBigInteger('Content_id')->nullable()->comment('Link to course_content for practice test questions');
            $table->string('Content_url', 255)->nullable()->comment('URL for mock interview or practice test content');
            $table->decimal('Score', 5, 2)->nullable()->comment('Score achieved in the tool');
            $table->boolean('Is_completed')->default(false)->comment('Whether the tool was completed');
            $table->timestamps();

            $table->foreign('User_id')
                  ->references('User_id')
                  ->on('users')
                  ->onDelete('cascade')
                  ->name('interview_preparation_user_id_foreign');
            $table->foreign('Content_id')
                  ->references('Content_id')
                  ->on('course_content')
                  ->onDelete('set null')
                  ->name('interview_preparation_content_id_foreign');
        });
    }

    public function down()
    {
        Schema::dropIfExists('interview_preparation');
    }
}
